/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBSEQUENCEMANAGER_H
#define DBSEQUENCEMANAGER_H

#include <string>
#include "../../exceptions/sqlexception.h"
#include "dbsequenceset.h"
#include "../dbconnection.h"
#include "../dbbasemanager.h"

/**
 * This class is used to manage operations concerning database tables. The class
 * provides many generic functions that can be used to retrieve/create/modify
 * database sequences.
 */
class DBSequenceManager : public DBBaseManager
{
					
public:

	/**
 	 * Constructor
   */		
  DBSequenceManager();

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBSequenceManager(DBConnection *poDBConn);
	
	/**
 	 * Destructor
   */		
	~DBSequenceManager();
			
	/**
	 * Used to retrieve the list of sequences for this connection.
	 * @return	a DBSequenceSet object that contains the view details
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void retrieveListOfSequences(DBSequenceSet & roDBSequenceSet) throw (SQLException, DBConnectionException);

	/**
	 * Used to modify the sequence comment.
	 * @param			rstrSequenceame		the name of the sequence
	 * @param			rstrComment				the comment to set for the sequence
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void modifySequenceComment(const string & rstrSequenceName, const string & rstrComment)
				throw (SQLException, DBConnectionException);			
			
};

#endif

