/*
    SPDX-FileCopyrightText: 2015 Vishesh Handa <vhanda@kde.org>

    SPDX-License-Identifier: LGPL-2.1-or-later
*/

#ifndef BALOO_EXTRACTORPROCESS_H
#define BALOO_EXTRACTORPROCESS_H

#include <QProcess>
#include <QObject>
#include <QTimer>
#include <QVector>

namespace Baloo {

class ExtractorProcess : public QObject
{
    Q_OBJECT
public:
    explicit ExtractorProcess(QObject* parent = nullptr);
    ~ExtractorProcess();

    void index(const QVector<quint64>& fileIds);
    void start();

Q_SIGNALS:
    void startedIndexingFile(QString filePath);
    void finishedIndexingFile(QString filePath);
    void done();
    void failed();

private Q_SLOTS:
    void slotIndexingFile();

private:
    const QString m_extractorPath;

    QProcess m_extractorProcess;
    QTimer m_timeCurrentFile;
    int m_processTimeout;
};
}

#endif // BALOO_EXTRACTORPROCESS_H
